/**
  Copyright (c) 2012 Freescale Semiconductor
  
  \file       mc_stage_tc.c
  \brief      This file contains the animations
  \author     Freescale Semiconductor
  \author     Automotive Systems Solutions Engineering
  \author     DB, r54930
  \version    1.0
  \date       16/Feb/2014
  
  * History:  16/Feb/2014- Initial Version

* Copyright (c) 2014, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
   
*/

#include "common.h"
#include "..\HIL\Graphics.h"
#include "..\HIL\Display.h"
#include "..\HIL\Flib.h"
#include "..\HAL\GALLO.h"
#include "..\SERVICES\DMAHandler.h"
#include "..\HIL\FontLibrary.h"
#include "GO_Utils.h"
#include "mc_parameters.h"
#include "FSLtime.h"
// Image objects
#include ".\Stage_tc\tc_misc.h"
#include ".\Tabs\tabO.h"
#include ".\Tabs\Icons.h"
// Fonts
#include "ARIAL34.h"
#include "ARIAL30.h"
//Data
#include "TextStrings.h"

/************/
/*  Defines */
/************/
#define TC_CC           0
#define TC_KMH          1
#define TC_MPH          2
#define TC_SPEED        3
#define TC_DWN_ARROW    4
#define TC_UP_ARROW     5
#define TC_AVG_ICON     6
/***********************************/
// ********  Constants  ************
/**********************************/

/********************/
/* Global Variables */
/********************/
extern uint8_t sKmTotal[9];
extern uint8_t sKmTrip[9];
vuint8_t tc_function = 0;
mc_stage_tc_parameters_t mc_stage_tc_parameters = {0};
mc_stage_tc_parameters_t mc_stage_tc_parameters_l = {0};
Graphics_Object_t SpeedGO = 
{
    (uint32_t)NULL_PTR, 56, 80, NULL_PTR, 0, 0, GRAPHICS_T8BPP, 255, 0, 0, GRAPHICS_CODING_RAWINT,0,0
};
Graphics_Object_t stage_tc_Text_RAM =
{
    (uint32_t)NULL_PTR, 400, 40, NULL_PTR, 0, 0, GRAPHICS_T8BPP, 255, 0, 0, GRAPHICS_CODING_RAWINT,0,0
};
Graphics_Object_t stage_tc_Text2_RAM =
{
    (uint32_t)NULL_PTR, 400, 160, NULL_PTR, 0, 0, GRAPHICS_T8BPP, 255, 0, 0, GRAPHICS_CODING_RAWINT,0,0
};
extern Graphics_Object_t tabsLine_RAM;
extern uint8_t AutoAnimate;
/*********************************/
/* Function prototypes ***********/
/*********************************/
void DrawSpeed(void);
void SetupSpeed(void);  
void SetupCruise(void);
void SetupFuelConsumption(void);
extern uint8_t CalculateKmTrip(uint32_t value);
uint8_t tabsPrint(
	Graphics_Object_t*  target,
	char* string, Font_FontType* font,int16_t xoffset, 
        uint16_t yoffset, Font_JustifyType justify, uint16_t maxWidth, uint8_t count
);
/*******************************/
/*  Code starts Here           */
/*******************************/
void mc_stage_tc(uint32_t CurrentFrame)
{
    uint32_t relative_fr;
    uint32_t temp32;
    uint8_t dmachnl,i, temp8, temp8b;
    Graphics_ErrorType Gret;
    
    if(mc_stage_tc_properties.frameLatch == 0u)
    {
        mc_stage_tc_properties.frameLatch = CurrentFrame;
    }
    relative_fr = CurrentFrame - mc_stage_tc_properties.frameLatch;
    
// Init objects     
    switch(relative_fr)
    {
      case 0:
          //give chance other moviclips to disable layers wihout affecting this one. b06623
          return;
      break;
      case 1:
        temp32 = (uint32_t)p_stage_tcSAM;
        // init some parameters
        mc_stage_tc_parameters_l.speed = mc_stage_tc_parameters.speed + 1; //force update b06623
        mc_stage_tc_parameters_l.mode = mc_global_parameters.units + 1;//force update b06623
        /*
        switch (mc_global_parameters.lang){
          case0:
            pTextStrings = *pTextStringsE;
          break;
          case1:
            pTextStrings = *pTextStringsS;
          break;
        }
        */
        mc_stage_tc_properties.autoDispose = 1; //supports AutoDispose
        //addr for Layer needs to be 64byte aligned
        if (temp32 & 0x3F) temp32 = (temp32 & 0xFFFFFFC0) + 0x40;
        stage_tc_Text_RAM.address = temp32;
        temp32 += stage_tc_Text_RAM.width * stage_tc_Text_RAM.height;  //
        if (temp32 & 0x3F) temp32 = (temp32 & 0xFFFFFFC0) + 0x40;
        stage_tc_Text2_RAM.address = temp32;
        temp32 += stage_tc_Text2_RAM.width * stage_tc_Text2_RAM.height;  //
         
        if (mc_stage_tc_parameters.function == 0) SetupSpeed();
        else if (mc_stage_tc_parameters.function == 1) SetupCruise();
        else if (mc_stage_tc_parameters.function == 2) SetupFuelConsumption();
      break;
      case 2:
        dmachnl = DMAHR_GetNextFreeChannel();
        // if there is no free DMA channel adjust the mc frame counter to do this again 
        if (dmachnl == DMAHR_NOCHNL) mc_stage_tc_properties.frameLatch++;
        else    Graphics_BlankArea(dmachnl, &stage_tc_Text_RAM, 0x00000000, NULL_PTR);
      break;      
      case 3:
        dmachnl = DMAHR_GetNextFreeChannel();
        // if there is no free DMA channel adjust the mc frame counter to do this again 
        if (dmachnl == DMAHR_NOCHNL) mc_stage_tc_properties.frameLatch++;
        else    Graphics_BlankArea(dmachnl, &stage_tc_Text2_RAM, 0x00000000, NULL_PTR);
      break;      
      case 4:
        if ((tabsPrint(&stage_tc_Text_RAM, (char *) &TS0e, 
            (Font_FontType*)&ARIAL34_Font,0, 0, FONT_CENTER, 0, 5)) != 0) 
              mc_stage_tc_properties.frameLatch++;
      break;      
      case 5:
        CalculateKmTrip(mc_stage_tc_parameters.shortTrip);
        if ((tabsPrint(&stage_tc_Text2_RAM, (char*) &sKmTrip, 
            (Font_FontType*)&ARIAL34_Font,0, 0, FONT_CENTER, 0, 8)) != 0) 
              mc_stage_tc_properties.frameLatch++;
      break;    
      case 6:
         Display_InitLayer(TC_TITLE,&stage_tc_Text_RAM, 200, 144);
         DCU_ForeGroundColor(TC_TITLE) = TABS_WHITE;
         DCU_BackGroundColor(TC_TITLE) = 0x0;
         DCU_LayerAlphaCfg(TC_TITLE) = 0;
         DCU_LayerChromaCfg(TC_TITLE) = 0;
      break;
      case 7:
        Display_InitLayer(TC_TC,&stage_tc_Text2_RAM, 200, 357);
        DCU_LayerSetHeight(TC_TC, 37);
        DCU_ForeGroundColor(TC_TC) = TABS_WHITE;
        DCU_BackGroundColor(TC_TC) = 0x0;
        DCU_LayerAlphaCfg(TC_TC) = 0; 
        DCU_LayerChromaCfg(TC_TC) = 0;
      break;
      case 8:
        CopyGO2GO(tc_misc_GObjectArray[TC_AVG_ICON], &stage_tc_Text2_RAM, 156,8);
      break;
      case 9:
        CopyGO2GO(Icons_GObjectArray[3], &stage_tc_Text2_RAM, 250,14);
      break;
      default:
      break;
    }
    switch (tc_function){
      case 0: //Digital speed
        DrawSpeed();
      break;
      case 1: //Cruise control
        
      break;
      case 2: //fuel consumption
        
      break;
      
    }  

// ANIMATION STIMULI *******************************************************************************
    // Had to slow down animation to 10FPS. At 60fps you can't see the numbers. It's too fast
    //removed code from here... added to the main.
/*        
    if((AutoAnimate) && (!(relative_fr % 6))){
          if(++mc_stage_tc_parameters.speed > 360) {
            mc_stage_tc_parameters.speed = 0;
            if(mc_stage_tc_parameters.mode) mc_global_parameters.units = 0;
            mc_global_parameters.units = 1;
          }
        }        
*/    
}
/**********************************************/

void DrawSpeed(void){
  uint32_t temp32;
  uint8_t temp8, temp8b;
        if(mc_stage_tc_parameters_l.speed != mc_stage_tc_parameters.speed){
        if(mc_stage_tc_parameters.mode) temp32 = (mc_stage_tc_parameters.speed * 6213)/10000;
        else temp32 = mc_stage_tc_parameters.speed;
        //
        temp8b = temp32/100;
        temp32 = (temp32%100);
        if(temp8b == 0) DCU_LayerDisable(D100_LAYER);
        else {
          //SpeedGO.width = Arial67_speed_FontGlyphSet[temp8b + 1].pixelWidth;
          SpeedGO.address = tc_misc_GObjectArray[TC_SPEED]->address + (SpeedGO.width * 80 * temp8b);
          Display_InitLayer(D100_LAYER,&SpeedGO,270,223);
        }

        temp8 = temp32/10;
        temp32 = (temp32%10);
        if((temp8 == 0) && (temp8b == 0))DCU_LayerDisable(D10_LAYER);
        else {
          //SpeedGO.width = Arial67_speed_FontGlyphSet[temp8b + 1].pixelWidth;
          SpeedGO.address = tc_misc_GObjectArray[TC_SPEED]->address + (SpeedGO.width * 80 * temp8);
          Display_InitLayer(D10_LAYER,&SpeedGO,326,223);
        }
        temp8 = temp32;
          //SpeedGO.width = Arial67_speed_FontGlyphSet[temp8b + 1].pixelWidth;
          SpeedGO.address = tc_misc_GObjectArray[TC_SPEED]->address + (SpeedGO.width * 80 * temp8);
          Display_InitLayer(D1_LAYER,&SpeedGO,382,223);
        mc_stage_tc_parameters_l.speed = mc_stage_tc_parameters.speed;
      }
      
      if(mc_stage_tc_parameters_l.mode != mc_global_parameters.units){
        if(mc_global_parameters.units) Display_InitLayer(MODE_LAYER,tc_misc_GObjectArray[TC_MPH],0x1C0,0x10A);
        else Display_InitLayer(MODE_LAYER,tc_misc_GObjectArray[TC_KMH],0x1C0,0x10A);
        mc_stage_tc_parameters_l.mode = mc_global_parameters.units;
        
      }
}

void SetupSpeed(void){
uint32_t i;
    for(i = D1_LAYER;i< (D1_LAYER + 4);i++){
          DCU_LayerAlphaCfg(i) = 2;
          DCU_LayerChromaCfg(i) = 1;
          Display_FGColor(i) = 0xFFFFFFFF;
          Display_BGColor(i) = 0x0;
    }
        //mc_stage_tc_parameters_l.mode++;
        //mc_stage_tc_parameters_l.speed++;
     Display_InitLayer(TC_LINE_BOTTOM,&tabsLine_RAM, 160, 351);
     DCU_TileMode(TC_LINE_BOTTOM, 1, 16, 4);
     DCU_LayerSetWidth(TC_LINE_BOTTOM, 480 );
     DCU_LayerSetHeight(TC_LINE_BOTTOM, 3);
     DCU_ForeGroundColor(TC_LINE_BOTTOM) = TABS_WHITE;
     DCU_BackGroundColor(TC_LINE_BOTTOM) = 0x0;
     DCU_LayerAlphaCfg(TC_LINE_BOTTOM) = 0;

     Display_InitLayer(TC_LINE_TOP,&tabsLine_RAM, 132, 186);
     DCU_TileMode(TC_LINE_TOP, 1, 16, 4);
     DCU_LayerSetWidth(TC_LINE_TOP, 536 );
     DCU_LayerSetHeight(TC_LINE_TOP, 3);
     DCU_ForeGroundColor(TC_LINE_TOP) = TABS_RED;
     DCU_BackGroundColor(TC_LINE_TOP) = 0x0;
     DCU_LayerAlphaCfg(TC_LINE_TOP) = 0;

     Display_InitLayer(TC_ARW_UP,tc_misc_GObjectArray[TC_UP_ARROW], 180, 356);
     DCU_ForeGroundColor(TC_ARW_UP) = TABS_WHITE;
     DCU_BackGroundColor(TC_ARW_UP) = 0x0;
     DCU_LayerAlphaCfg(TC_ARW_UP) = 0;

     Display_InitLayer(TC_ARW_DWN,tc_misc_GObjectArray[TC_DWN_ARROW], 180, 381);
     DCU_ForeGroundColor(TC_ARW_DWN) = TABS_WHITE;
     DCU_BackGroundColor(TC_ARW_DWN) = 0x0;
     DCU_LayerAlphaCfg(TC_ARW_DWN) = 0;
     DCU_LayerChromaCfg(TC_ARW_DWN) = 0;	 

}

void SetupCruise(void){}
void SetupFuelConsumption(void){}

void mc_stage_tc_Dispose()
{
  DCU_LayerDisable(D100_LAYER);
  DCU_LayerDisable(D10_LAYER);
  DCU_LayerDisable(D1_LAYER);
  DCU_LayerDisable(MODE_LAYER);	
  DCU_LayerDisable(TC_LINE_TOP);	
  DCU_LayerDisable(TC_LINE_BOTTOM);
  DCU_LayerDisable(TC_ICON);
  DCU_LayerDisable(TC_TITLE);
  DCU_LayerDisable(TC_TC);
  DCU_LayerDisable(TC_ARW_UP);
  DCU_LayerDisable(TC_ARW_DWN);
}

void mc_stage_tc_Refresh()
{

}
